/*:
 * @plugindesc Allows the player to look around without moving by holding the Page Up key, with fixes for sprinting glitches.
 * @author Clay Davis
 * 
 * @help 
 * This plugin changes how movement and direction work:
 * 
 * - When the player holds the Page Up key, they can look around 
 *   (change direction) without moving.
 * - When the Page Up key is released, normal movement resumes.
 * - Sprinting and movement transitions are now smoother.
 * 
 * Purpose:
 * - This is useful in farming games or scenarios where precise 
 *   alignment with tiles is important, allowing players to adjust
 *   their direction without unintended movement.
 * 
 * Notes:
 * - Directional keys change the player's direction when Page Up 
 *   is held.
 * - Normal movement and sprinting are unaffected when Page Up is 
 *   not held.
 * 
 * No plugin commands are required. Simply install the plugin, and
 * the feature will automatically apply to gameplay.
 */

(() => {
    const lookAroundKey = 'pageup'; // Key used for looking around (default: Page Up)

    // Override the moveByInput function for the player
    const _Game_Player_moveByInput = Game_Player.prototype.moveByInput;
    Game_Player.prototype.moveByInput = function() {
        // Prevent movement if the player is already moving or restricted
        if (this.isMoving() || !$gamePlayer.canMove()) return;

        // Check if the player is holding the look-around key
        if (Input.isPressed(lookAroundKey)) {
            // Only change direction without movement
            if (Input.isPressed('up')) this.setDirection(8); // Face up
            else if (Input.isPressed('down')) this.setDirection(2); // Face down
            else if (Input.isPressed('left')) this.setDirection(4); // Face left
            else if (Input.isPressed('right')) this.setDirection(6); // Face right
        } else {
            // Normal movement with smooth handling for sprinting
            const dash = this.isDashButtonPressed();
            const moveSpeed = dash ? this.realMoveSpeed() : 4; // Adjust speed dynamically

            if (Input.isPressed('up')) {
                this.setMoveSpeed(moveSpeed);
                this.moveStraight(8); // Move up
            } else if (Input.isPressed('down')) {
                this.setMoveSpeed(moveSpeed);
                this.moveStraight(2); // Move down
            } else if (Input.isPressed('left')) {
                this.setMoveSpeed(moveSpeed);
                this.moveStraight(4); // Move left
            } else if (Input.isPressed('right')) {
                this.setMoveSpeed(moveSpeed);
                this.moveStraight(6); // Move right
            }
        }
    };

    // Ensure proper movement speed is handled during sprinting
    Game_Player.prototype.isDashButtonPressed = function() {
        return Input.isPressed('shift') || $gameTemp.isPlaytest(); // Dash logic
    };
})();